/*
 * Decompiled with CFR 0.152.
 */
package org.gdal.gnm;

import java.util.Vector;
import org.gdal.gdal.MajorObject;
import org.gdal.gnm.GraphAlgorithm;
import org.gdal.gnm.SWIGTYPE_p_CPLErr;
import org.gdal.gnm.gnmJNI;
import org.gdal.ogr.Feature;
import org.gdal.ogr.Layer;
import org.gdal.osr.SpatialReference;

public class Network
extends MajorObject {
    private transient long swigCPtr;

    protected Network(long cPtr, boolean cMemoryOwn) {
        super(gnmJNI.Network_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Network obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(Network obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                gnmJNI.delete_Network(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof Network) {
            equal = ((Network)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public int GetVersion() {
        return gnmJNI.Network_GetVersion(this.swigCPtr, this);
    }

    public String GetName() {
        return gnmJNI.Network_GetName(this.swigCPtr, this);
    }

    public Feature GetFeatureByGlobalFID(long GFID) {
        long cPtr = gnmJNI.Network_GetFeatureByGlobalFID(this.swigCPtr, this, GFID);
        return cPtr == 0L ? null : new Feature(cPtr, true);
    }

    public Layer GetPath(long nStartFID, long nEndFID, GraphAlgorithm eAlgorithm, Vector options) {
        long cPtr = gnmJNI.Network_GetPath__SWIG_0(this.swigCPtr, this, nStartFID, nEndFID, eAlgorithm.swigValue(), options);
        return cPtr == 0L ? null : new Layer(cPtr, true);
    }

    public Layer GetPath(long nStartFID, long nEndFID, GraphAlgorithm eAlgorithm) {
        long cPtr = gnmJNI.Network_GetPath__SWIG_1(this.swigCPtr, this, nStartFID, nEndFID, eAlgorithm.swigValue());
        return cPtr == 0L ? null : new Layer(cPtr, true);
    }

    public SWIGTYPE_p_CPLErr DisconnectAll() {
        return new SWIGTYPE_p_CPLErr(gnmJNI.Network_DisconnectAll(this.swigCPtr, this), true);
    }

    public String GetProjection() {
        return gnmJNI.Network_GetProjection(this.swigCPtr, this);
    }

    public String GetProjectionRef() {
        return gnmJNI.Network_GetProjectionRef(this.swigCPtr, this);
    }

    public Vector GetFileList() {
        return gnmJNI.Network_GetFileList(this.swigCPtr, this);
    }

    public Layer CreateLayer(String name, SpatialReference srs, int geom_type, Vector options) {
        long cPtr = gnmJNI.Network_CreateLayer__SWIG_0(this.swigCPtr, this, name, SpatialReference.getCPtr(srs), srs, geom_type, options);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer CreateLayer(String name, SpatialReference srs, int geom_type) {
        long cPtr = gnmJNI.Network_CreateLayer__SWIG_1(this.swigCPtr, this, name, SpatialReference.getCPtr(srs), srs, geom_type);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer CreateLayer(String name, SpatialReference srs) {
        long cPtr = gnmJNI.Network_CreateLayer__SWIG_2(this.swigCPtr, this, name, SpatialReference.getCPtr(srs), srs);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer CreateLayer(String name) {
        long cPtr = gnmJNI.Network_CreateLayer__SWIG_3(this.swigCPtr, this, name);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer CopyLayer(Layer src_layer, String new_name, Vector options) {
        long cPtr = gnmJNI.Network_CopyLayer__SWIG_0(this.swigCPtr, this, Layer.getCPtr(src_layer), src_layer, new_name, options);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer CopyLayer(Layer src_layer, String new_name) {
        long cPtr = gnmJNI.Network_CopyLayer__SWIG_1(this.swigCPtr, this, Layer.getCPtr(src_layer), src_layer, new_name);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public int DeleteLayer(int index) {
        return gnmJNI.Network_DeleteLayer(this.swigCPtr, this, index);
    }

    public int GetLayerCount() {
        return gnmJNI.Network_GetLayerCount(this.swigCPtr, this);
    }

    public Layer GetLayerByIndex(int index) {
        long cPtr = gnmJNI.Network_GetLayerByIndex(this.swigCPtr, this, index);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public Layer GetLayerByName(String layer_name) {
        long cPtr = gnmJNI.Network_GetLayerByName(this.swigCPtr, this, layer_name);
        Layer ret = null;
        if (cPtr != 0L) {
            ret = new Layer(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public boolean TestCapability(String cap) {
        return gnmJNI.Network_TestCapability(this.swigCPtr, this, cap);
    }

    public int StartTransaction(int force) {
        return gnmJNI.Network_StartTransaction__SWIG_0(this.swigCPtr, this, force);
    }

    public int StartTransaction() {
        return gnmJNI.Network_StartTransaction__SWIG_1(this.swigCPtr, this);
    }

    public int CommitTransaction() {
        return gnmJNI.Network_CommitTransaction(this.swigCPtr, this);
    }

    public int RollbackTransaction() {
        return gnmJNI.Network_RollbackTransaction(this.swigCPtr, this);
    }
}

