# Author: Jeff McKenna, GatewayGeo, info@gatewaygeomatics.com

# Execute this file through Windows PowerShell before running the MapServer, 
# GDAL, PROJ, and other commandline utilities.
#
# After executing this file you should be able 
# to run the utilities from any commandline location.

$relativeMS4WPath = "..\ms4w"
$absoluteMS4WPath = Resolve-Path $relativeMS4WPath

$Env:PATH += (";$absoluteMS4WPath\Apache\cgi-bin;$absoluteMS4WPath\tools\gdal-ogr;$absoluteMS4WPath\tools\mapserv;
             $absoluteMS4WPath\tools\shapelib;$absoluteMS4WPath\tools\proj;$absoluteMS4WPath\tools\shp2tile;$absoluteMS4WPath\tools\shpdiff;
             $absoluteMS4WPath\tools\avce00;$absoluteMS4WPath\gdalbindings\python\gdal;$absoluteMS4WPath\tools\php;$absoluteMS4WPath\tools\mapcache;
             $absoluteMS4WPath\tools\berkeley-db;$absoluteMS4WPath\tools\sqlite;$absoluteMS4WPath\tools\spatialite;$absoluteMS4WPath\tools\unixutils;
             $absoluteMS4WPath\tools\openssl;$absoluteMS4WPath\tools\curl;$absoluteMS4WPath\tools\geotiff;$absoluteMS4WPath\tools\jpeg;$absoluteMS4WPath\tools\protobuf;
             $absoluteMS4WPath\Python;$absoluteMS4WPath\Python\Scripts;$absoluteMS4WPath\tools\osm2pgsql;$absoluteMS4WPath\tools\netcdf;$absoluteMS4WPath\tools\pdal;
             $absoluteMS4WPath\tools\libtiff;$absoluteMS4WPath\tools\pdf;$absoluteMS4WPath\tools\deflate;$absoluteMS4WPath\tools\webp;
             $absoluteMS4WPath\tools\geos;$absoluteMS4WPath\tools\zstd;$absoluteMS4WPath\tools\lz4;$absoluteMS4WPath\tools\uriparser;
             $absoluteMS4WPath\tools\qhull;$absoluteMS4WPath\tools\libxml2;$absoluteMS4WPath\tools\ogdi;$absoluteMS4WPath\tools\brotli;
             $absoluteMS4WPath\tools\jansson;$absoluteMS4WPath\tools\harfbuzz")

$Env:USE_PATH_FOR_GDAL_PYTHON = "YES"
$Env:PYTHONHOME = "$absoluteMS4WPath\Python"
$Env:PYTHONPATH = "$absoluteMS4WPath\Apache\cgi-bin;$absoluteMS4WPath\Python\DLLs;$absoluteMS4WPath\Python\Lib;$absoluteMS4WPath\Python\Lib\site-packages;$absoluteMS4WPath\Python;$absoluteMS4WPath\Python\Lib\site-packages\osgeo_utils;%PYTHONPATH%"
$Env:PYTHONUTF8 = "1"
$Env:GDAL_DATA = "$absoluteMS4WPath\gdaldata"
$Env:GDAL_DRIVER_PATH = "$absoluteMS4WPath\gdalplugins"
$Env:GDAL_FILENAME_IS_UTF8 = "1"
$Env:VSI_CACHE = "TRUE"
$Env:VSI_CACHE_SIZE = "1000000"
$Env:CPL_ZIP_ENCODING = "UTF-8"
$Env:PROJ_DATA = "$absoluteMS4WPath\share\proj"
$Env:PROJ_USER_WRITABLE_DIRECTORY = "$absoluteMS4WPath\share\proj"
$Env:CURL_CA_BUNDLE = "$absoluteMS4WPath\Apache\conf\ca-bundle\cacert.pem"
$Env:SSL_CERT_FILE = "$absoluteMS4WPath\Apache\conf\ca-bundle\cacert.pem"
$Env:OPENSSL_CONF = "$absoluteMS4WPath\tools\openssl\openssl.cnf"
$Env:PDAL_DRIVER_PATH = "$absoluteMS4WPath\Apache\cgi-bin"
$Env:MAPSERVER_CONFIG_FILE = "$absoluteMS4WPath$absoluteMS4WPath.conf"

Write-Output "mapserv, GDAL, Python, PHP, PROJ, and commandline MS4W tools path set"
Write-Output "happy MapServ-ing!"