/*
 * Decompiled with CFR 0.152.
 */
package org.gdal.gdal;

import java.util.Hashtable;
import java.util.Vector;
import org.gdal.gdal.Attribute;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.Dimension;
import org.gdal.gdal.ExtendedDataType;
import org.gdal.gdal.Group;
import org.gdal.gdal.ProgressCallback;
import org.gdal.gdal.Statistics;
import org.gdal.gdal.gdalJNI;
import org.gdal.osr.SpatialReference;

public class MDArray {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected MDArray(long cPtr, boolean cMemoryOwn) {
        if (cPtr == 0L) {
            throw new RuntimeException();
        }
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(MDArray obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                gdalJNI.delete_MDArray(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public Dimension[] GetDimensions() {
        long size = this.GetDimensionCount();
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("java array can hold at most 2147483647 values.");
        }
        Dimension[] arr = new Dimension[(int)size];
        int i = 0;
        while ((long)i < size) {
            Dimension dim;
            arr[i] = dim = this.GetDimension(i);
            ++i;
        }
        return arr;
    }

    private long[] defaultSteps(int numDims) {
        long[] retVal = new long[numDims];
        for (int i = 0; i < numDims; ++i) {
            retVal[i] = 1L;
        }
        return retVal;
    }

    private long[] defaultStrides(long[] counts) {
        int numDims = counts.length;
        long[] retVal = new long[numDims];
        if (numDims > 0) {
            retVal[numDims - 1] = 1L;
            for (int i = numDims - 2; i >= 0; --i) {
                retVal[i] = retVal[i + 1] * counts[i + 1];
            }
        }
        return retVal;
    }

    public boolean Read(long[] starts, long[] counts, long[] steps, byte[] outputBuffer) {
        return this.Read(starts, counts, steps, this.defaultStrides(counts), outputBuffer);
    }

    public boolean Read(long[] starts, long[] counts, long[] steps, short[] outputBuffer) {
        return this.Read(starts, counts, steps, this.defaultStrides(counts), outputBuffer);
    }

    public boolean Read(long[] starts, long[] counts, long[] steps, int[] outputBuffer) {
        return this.Read(starts, counts, steps, this.defaultStrides(counts), outputBuffer);
    }

    public boolean Read(long[] starts, long[] counts, long[] steps, long[] outputBuffer) {
        return this.Read(starts, counts, steps, this.defaultStrides(counts), outputBuffer);
    }

    public boolean Read(long[] starts, long[] counts, long[] steps, float[] outputBuffer) {
        return this.Read(starts, counts, steps, this.defaultStrides(counts), outputBuffer);
    }

    public boolean Read(long[] starts, long[] counts, long[] steps, double[] outputBuffer) {
        return this.Read(starts, counts, steps, this.defaultStrides(counts), outputBuffer);
    }

    public boolean Read(long[] starts, long[] counts, byte[] outputBuffer) {
        return this.Read(starts, counts, this.defaultSteps(counts.length), outputBuffer);
    }

    public boolean Read(long[] starts, long[] counts, short[] outputBuffer) {
        return this.Read(starts, counts, this.defaultSteps(counts.length), outputBuffer);
    }

    public boolean Read(long[] starts, long[] counts, int[] outputBuffer) {
        return this.Read(starts, counts, this.defaultSteps(counts.length), outputBuffer);
    }

    public boolean Read(long[] starts, long[] counts, long[] outputBuffer) {
        return this.Read(starts, counts, this.defaultSteps(counts.length), outputBuffer);
    }

    public boolean Read(long[] starts, long[] counts, float[] outputBuffer) {
        return this.Read(starts, counts, this.defaultSteps(counts.length), outputBuffer);
    }

    public boolean Read(long[] starts, long[] counts, double[] outputBuffer) {
        return this.Read(starts, counts, this.defaultSteps(counts.length), outputBuffer);
    }

    public boolean Write(long[] starts, long[] counts, long[] steps, byte[] inputBuffer) {
        return this.Write(starts, counts, steps, this.defaultStrides(counts), inputBuffer);
    }

    public boolean Write(long[] starts, long[] counts, long[] steps, short[] inputBuffer) {
        return this.Write(starts, counts, steps, this.defaultStrides(counts), inputBuffer);
    }

    public boolean Write(long[] starts, long[] counts, long[] steps, int[] inputBuffer) {
        return this.Write(starts, counts, steps, this.defaultStrides(counts), inputBuffer);
    }

    public boolean Write(long[] starts, long[] counts, long[] steps, long[] inputBuffer) {
        return this.Write(starts, counts, steps, this.defaultStrides(counts), inputBuffer);
    }

    public boolean Write(long[] starts, long[] counts, long[] steps, float[] inputBuffer) {
        return this.Write(starts, counts, steps, this.defaultStrides(counts), inputBuffer);
    }

    public boolean Write(long[] starts, long[] counts, long[] steps, double[] inputBuffer) {
        return this.Write(starts, counts, steps, this.defaultStrides(counts), inputBuffer);
    }

    public boolean Write(long[] starts, long[] counts, byte[] inputBuffer) {
        return this.Write(starts, counts, this.defaultSteps(counts.length), inputBuffer);
    }

    public boolean Write(long[] starts, long[] counts, short[] inputBuffer) {
        return this.Write(starts, counts, this.defaultSteps(counts.length), inputBuffer);
    }

    public boolean Write(long[] starts, long[] counts, int[] inputBuffer) {
        return this.Write(starts, counts, this.defaultSteps(counts.length), inputBuffer);
    }

    public boolean Write(long[] starts, long[] counts, long[] inputBuffer) {
        return this.Write(starts, counts, this.defaultSteps(counts.length), inputBuffer);
    }

    public boolean Write(long[] starts, long[] counts, float[] inputBuffer) {
        return this.Write(starts, counts, this.defaultSteps(counts.length), inputBuffer);
    }

    public boolean Write(long[] starts, long[] counts, double[] inputBuffer) {
        return this.Write(starts, counts, this.defaultSteps(counts.length), inputBuffer);
    }

    public String GetName() {
        return gdalJNI.MDArray_GetName(this.swigCPtr, this);
    }

    public String GetFullName() {
        return gdalJNI.MDArray_GetFullName(this.swigCPtr, this);
    }

    public long GetTotalElementsCount() {
        return gdalJNI.MDArray_GetTotalElementsCount(this.swigCPtr, this);
    }

    public long GetDimensionCount() {
        return gdalJNI.MDArray_GetDimensionCount(this.swigCPtr, this);
    }

    public ExtendedDataType GetDataType() {
        long cPtr = gdalJNI.MDArray_GetDataType(this.swigCPtr, this);
        return cPtr == 0L ? null : new ExtendedDataType(cPtr, true);
    }

    public Hashtable GetStructuralInfo() {
        return gdalJNI.MDArray_GetStructuralInfo(this.swigCPtr, this);
    }

    public int Resize(long[] newDimensions, Vector options) {
        return gdalJNI.MDArray_Resize__SWIG_0(this.swigCPtr, this, newDimensions, options);
    }

    public int Resize(long[] newDimensions) {
        return gdalJNI.MDArray_Resize__SWIG_1(this.swigCPtr, this, newDimensions);
    }

    public Attribute GetAttribute(String name) {
        long cPtr = gdalJNI.MDArray_GetAttribute(this.swigCPtr, this, name);
        return cPtr == 0L ? null : new Attribute(cPtr, true);
    }

    public Attribute CreateAttribute(String name, long[] dimensions, ExtendedDataType data_type, Vector options) {
        long cPtr = gdalJNI.MDArray_CreateAttribute__SWIG_0(this.swigCPtr, this, name, dimensions, ExtendedDataType.getCPtr(data_type), data_type, options);
        return cPtr == 0L ? null : new Attribute(cPtr, true);
    }

    public Attribute CreateAttribute(String name, long[] dimensions, ExtendedDataType data_type) {
        long cPtr = gdalJNI.MDArray_CreateAttribute__SWIG_1(this.swigCPtr, this, name, dimensions, ExtendedDataType.getCPtr(data_type), data_type);
        return cPtr == 0L ? null : new Attribute(cPtr, true);
    }

    public int DeleteAttribute(String name, Vector options) {
        return gdalJNI.MDArray_DeleteAttribute__SWIG_0(this.swigCPtr, this, name, options);
    }

    public int DeleteAttribute(String name) {
        return gdalJNI.MDArray_DeleteAttribute__SWIG_1(this.swigCPtr, this, name);
    }

    public void GetNoDataValueAsDouble(Double[] val) {
        gdalJNI.MDArray_GetNoDataValueAsDouble(this.swigCPtr, this, val);
    }

    public String GetNoDataValueAsString() {
        return gdalJNI.MDArray_GetNoDataValueAsString(this.swigCPtr, this);
    }

    public int SetNoDataValueDouble(double d) {
        return gdalJNI.MDArray_SetNoDataValueDouble(this.swigCPtr, this, d);
    }

    public int SetNoDataValueString(String nodata) {
        return gdalJNI.MDArray_SetNoDataValueString(this.swigCPtr, this, nodata);
    }

    public int DeleteNoDataValue() {
        return gdalJNI.MDArray_DeleteNoDataValue(this.swigCPtr, this);
    }

    public void GetOffset(Double[] val) {
        gdalJNI.MDArray_GetOffset(this.swigCPtr, this, val);
    }

    public int GetOffsetStorageType() {
        return gdalJNI.MDArray_GetOffsetStorageType(this.swigCPtr, this);
    }

    public void GetScale(Double[] val) {
        gdalJNI.MDArray_GetScale(this.swigCPtr, this, val);
    }

    public int GetScaleStorageType() {
        return gdalJNI.MDArray_GetScaleStorageType(this.swigCPtr, this);
    }

    public int SetOffset(double val, int storageType) {
        return gdalJNI.MDArray_SetOffset__SWIG_0(this.swigCPtr, this, val, storageType);
    }

    public int SetOffset(double val) {
        return gdalJNI.MDArray_SetOffset__SWIG_1(this.swigCPtr, this, val);
    }

    public int SetScale(double val, int storageType) {
        return gdalJNI.MDArray_SetScale__SWIG_0(this.swigCPtr, this, val, storageType);
    }

    public int SetScale(double val) {
        return gdalJNI.MDArray_SetScale__SWIG_1(this.swigCPtr, this, val);
    }

    public int SetUnit(String unit) {
        return gdalJNI.MDArray_SetUnit(this.swigCPtr, this, unit);
    }

    public String GetUnit() {
        return gdalJNI.MDArray_GetUnit(this.swigCPtr, this);
    }

    public int SetSpatialRef(SpatialReference srs) {
        return gdalJNI.MDArray_SetSpatialRef(this.swigCPtr, this, SpatialReference.getCPtr(srs), srs);
    }

    public SpatialReference GetSpatialRef() {
        long cPtr = gdalJNI.MDArray_GetSpatialRef(this.swigCPtr, this);
        return cPtr == 0L ? null : new SpatialReference(cPtr, true);
    }

    public MDArray GetView(String viewExpr) {
        long cPtr = gdalJNI.MDArray_GetView(this.swigCPtr, this, viewExpr);
        return cPtr == 0L ? null : new MDArray(cPtr, true);
    }

    public MDArray Transpose(int[] axisMap) {
        long cPtr = gdalJNI.MDArray_Transpose(this.swigCPtr, this, axisMap);
        return cPtr == 0L ? null : new MDArray(cPtr, true);
    }

    public MDArray GetUnscaled() {
        long cPtr = gdalJNI.MDArray_GetUnscaled(this.swigCPtr, this);
        return cPtr == 0L ? null : new MDArray(cPtr, true);
    }

    public MDArray GetMask(Vector options) {
        long cPtr = gdalJNI.MDArray_GetMask__SWIG_0(this.swigCPtr, this, options);
        return cPtr == 0L ? null : new MDArray(cPtr, true);
    }

    public MDArray GetMask() {
        long cPtr = gdalJNI.MDArray_GetMask__SWIG_1(this.swigCPtr, this);
        return cPtr == 0L ? null : new MDArray(cPtr, true);
    }

    public MDArray GetGridded(String pszGridOptions, MDArray xArray, MDArray yArray, Vector options) {
        long cPtr = gdalJNI.MDArray_GetGridded__SWIG_0(this.swigCPtr, this, pszGridOptions, MDArray.getCPtr(xArray), xArray, MDArray.getCPtr(yArray), yArray, options);
        return cPtr == 0L ? null : new MDArray(cPtr, true);
    }

    public MDArray GetGridded(String pszGridOptions, MDArray xArray, MDArray yArray) {
        long cPtr = gdalJNI.MDArray_GetGridded__SWIG_1(this.swigCPtr, this, pszGridOptions, MDArray.getCPtr(xArray), xArray, MDArray.getCPtr(yArray), yArray);
        return cPtr == 0L ? null : new MDArray(cPtr, true);
    }

    public MDArray GetGridded(String pszGridOptions, MDArray xArray) {
        long cPtr = gdalJNI.MDArray_GetGridded__SWIG_2(this.swigCPtr, this, pszGridOptions, MDArray.getCPtr(xArray), xArray);
        return cPtr == 0L ? null : new MDArray(cPtr, true);
    }

    public MDArray GetGridded(String pszGridOptions) {
        long cPtr = gdalJNI.MDArray_GetGridded__SWIG_3(this.swigCPtr, this, pszGridOptions);
        return cPtr == 0L ? null : new MDArray(cPtr, true);
    }

    public Dataset AsClassicDataset(long iXDim, long iYDim, Group hRootGroup, Vector options) {
        long cPtr = gdalJNI.MDArray_AsClassicDataset__SWIG_0(this.swigCPtr, this, iXDim, iYDim, Group.getCPtr(hRootGroup), hRootGroup, options);
        return cPtr == 0L ? null : new Dataset(cPtr, true);
    }

    public Dataset AsClassicDataset(long iXDim, long iYDim, Group hRootGroup) {
        long cPtr = gdalJNI.MDArray_AsClassicDataset__SWIG_1(this.swigCPtr, this, iXDim, iYDim, Group.getCPtr(hRootGroup), hRootGroup);
        return cPtr == 0L ? null : new Dataset(cPtr, true);
    }

    public Dataset AsClassicDataset(long iXDim, long iYDim) {
        long cPtr = gdalJNI.MDArray_AsClassicDataset__SWIG_2(this.swigCPtr, this, iXDim, iYDim);
        return cPtr == 0L ? null : new Dataset(cPtr, true);
    }

    public Statistics GetStatistics(boolean approx_ok, boolean force, ProgressCallback callback) {
        long cPtr = gdalJNI.MDArray_GetStatistics__SWIG_0(this.swigCPtr, this, approx_ok, force, callback);
        return cPtr == 0L ? null : new Statistics(cPtr, false);
    }

    public Statistics GetStatistics(boolean approx_ok, boolean force) {
        long cPtr = gdalJNI.MDArray_GetStatistics__SWIG_2(this.swigCPtr, this, approx_ok, force);
        return cPtr == 0L ? null : new Statistics(cPtr, false);
    }

    public Statistics GetStatistics(boolean approx_ok) {
        long cPtr = gdalJNI.MDArray_GetStatistics__SWIG_3(this.swigCPtr, this, approx_ok);
        return cPtr == 0L ? null : new Statistics(cPtr, false);
    }

    public Statistics GetStatistics() {
        long cPtr = gdalJNI.MDArray_GetStatistics__SWIG_4(this.swigCPtr, this);
        return cPtr == 0L ? null : new Statistics(cPtr, false);
    }

    public Statistics ComputeStatistics(boolean approx_ok, ProgressCallback callback, Vector options) {
        long cPtr = gdalJNI.MDArray_ComputeStatistics__SWIG_0(this.swigCPtr, this, approx_ok, callback, options);
        return cPtr == 0L ? null : new Statistics(cPtr, false);
    }

    public Statistics ComputeStatistics(boolean approx_ok, ProgressCallback callback) {
        long cPtr = gdalJNI.MDArray_ComputeStatistics__SWIG_1(this.swigCPtr, this, approx_ok, callback);
        return cPtr == 0L ? null : new Statistics(cPtr, false);
    }

    public Statistics ComputeStatistics(boolean approx_ok) {
        long cPtr = gdalJNI.MDArray_ComputeStatistics__SWIG_3(this.swigCPtr, this, approx_ok);
        return cPtr == 0L ? null : new Statistics(cPtr, false);
    }

    public Statistics ComputeStatistics() {
        long cPtr = gdalJNI.MDArray_ComputeStatistics__SWIG_4(this.swigCPtr, this);
        return cPtr == 0L ? null : new Statistics(cPtr, false);
    }

    public boolean Cache(Vector options) {
        return gdalJNI.MDArray_Cache__SWIG_0(this.swigCPtr, this, options);
    }

    public boolean Cache() {
        return gdalJNI.MDArray_Cache__SWIG_1(this.swigCPtr, this);
    }

    public int Rename(String newName) {
        return gdalJNI.MDArray_Rename(this.swigCPtr, this, newName);
    }

    public int GetOverviewCount() {
        return gdalJNI.MDArray_GetOverviewCount(this.swigCPtr, this);
    }

    public MDArray GetOverview(int idx) {
        long cPtr = gdalJNI.MDArray_GetOverview(this.swigCPtr, this, idx);
        return cPtr == 0L ? null : new MDArray(cPtr, true);
    }

    public Dimension GetDimension(long index) {
        long cPtr = gdalJNI.MDArray_GetDimension(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new Dimension(cPtr, true);
    }

    public boolean Read(long[] starts, long[] counts, long[] steps, long[] strides, byte[] arrayOut) {
        return gdalJNI.MDArray_Read__SWIG_0(this.swigCPtr, this, starts, counts, steps, strides, arrayOut);
    }

    public boolean Read(long[] starts, long[] counts, long[] steps, long[] strides, short[] arrayOut) {
        return gdalJNI.MDArray_Read__SWIG_1(this.swigCPtr, this, starts, counts, steps, strides, arrayOut);
    }

    public boolean Read(long[] starts, long[] counts, long[] steps, long[] strides, int[] arrayOut) {
        return gdalJNI.MDArray_Read__SWIG_2(this.swigCPtr, this, starts, counts, steps, strides, arrayOut);
    }

    public boolean Read(long[] starts, long[] counts, long[] steps, long[] strides, long[] arrayOut) {
        return gdalJNI.MDArray_Read__SWIG_3(this.swigCPtr, this, starts, counts, steps, strides, arrayOut);
    }

    public boolean Read(long[] starts, long[] counts, long[] steps, long[] strides, float[] arrayOut) {
        return gdalJNI.MDArray_Read__SWIG_4(this.swigCPtr, this, starts, counts, steps, strides, arrayOut);
    }

    public boolean Read(long[] starts, long[] counts, long[] steps, long[] strides, double[] arrayOut) {
        return gdalJNI.MDArray_Read__SWIG_5(this.swigCPtr, this, starts, counts, steps, strides, arrayOut);
    }

    public boolean Write(long[] starts, long[] counts, long[] steps, long[] strides, byte[] arrayIn) {
        return gdalJNI.MDArray_Write__SWIG_0(this.swigCPtr, this, starts, counts, steps, strides, arrayIn);
    }

    public boolean Write(long[] starts, long[] counts, long[] steps, long[] strides, short[] arrayIn) {
        return gdalJNI.MDArray_Write__SWIG_1(this.swigCPtr, this, starts, counts, steps, strides, arrayIn);
    }

    public boolean Write(long[] starts, long[] counts, long[] steps, long[] strides, int[] arrayIn) {
        return gdalJNI.MDArray_Write__SWIG_2(this.swigCPtr, this, starts, counts, steps, strides, arrayIn);
    }

    public boolean Write(long[] starts, long[] counts, long[] steps, long[] strides, long[] arrayIn) {
        return gdalJNI.MDArray_Write__SWIG_3(this.swigCPtr, this, starts, counts, steps, strides, arrayIn);
    }

    public boolean Write(long[] starts, long[] counts, long[] steps, long[] strides, float[] arrayIn) {
        return gdalJNI.MDArray_Write__SWIG_4(this.swigCPtr, this, starts, counts, steps, strides, arrayIn);
    }

    public boolean Write(long[] starts, long[] counts, long[] steps, long[] strides, double[] arrayIn) {
        return gdalJNI.MDArray_Write__SWIG_5(this.swigCPtr, this, starts, counts, steps, strides, arrayIn);
    }
}

